-- Library and Use statements for IEEE packages
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use ieee.std_logic_unsigned.all;

entity top is
port(
Clk  : in  std_logic;
CNT : out std_logic_vector (59 downto 0)
);

end top;

architecture behave of top is

component PLL01 is
    port(
        clki_i: in std_logic;
        clkop_o: out std_logic
    );
end component;

Component GenCNT is
generic (N : integer := 4);
port(
	Clk, CE  : in  std_logic;
	CNT : out std_logic_vector (N-1 downto 0)
);
end component;

signal CNT1: std_logic_vector (1 downto 0):="00";
signal CNT2: std_logic_vector (57 downto 0):= (others =>'0');
signal CE,CLKo : std_logic;


begin

--MyPLL: PLL01 port map(
    --clki_i=> CLK,
    --clkop_o=> CLKo
--);

CLKo <= clk; 

myCNT1 : GenCNT 
generic map (N => 2)
port map(
	Clk 	=> CLKo, 
	CE  	=> '1',
	CNT 	=> CNT1
	);

CE <= '1' when CNT1="11" else '0';

myCNT2 : GenCNT 
generic map (N => 58)
port map(
	Clk 	=> CLKo, 
	CE  	=> CE,
	CNT 	=> CNT2
	);
process (clk)
begin
if rising_edge(clk) then
CNT <= CNT2 & CNT1;
end if; 
end process;

end behave;